(function () {
  const styleMaps = {
    bold: {
      a: "𝗮",
      b: "𝗯",
      c: "𝗰",
      d: "𝗱",
      e: "𝗲",
      f: "𝗳",
      g: "𝗴",
      h: "𝗵",
      i: "𝗶",
      j: "𝗷",
      k: "𝗸",
      l: "𝗹",
      m: "𝗺",
      n: "𝗻",
      o: "𝗼",
      p: "𝗽",
      q: "𝗾",
      r: "𝗿",
      s: "𝘀",
      t: "𝘁",
      u: "𝘂",
      v: "𝘃",
      w: "𝘄",
      x: "𝘅",
      y: "𝘆",
      z: "𝘇",
      A: "𝗔",
      B: "𝗕",
      C: "𝗖",
      D: "𝗗",
      E: "𝗘",
      F: "𝗙",
      G: "𝗚",
      H: "𝗛",
      I: "𝗜",
      J: "𝗝",
      K: "𝗞",
      L: "𝗟",
      M: "𝗠",
      N: "𝗡",
      O: "𝗢",
      P: "𝗣",
      Q: "𝗤",
      R: "𝗥",
      S: "𝗦",
      T: "𝗧",
      U: "𝗨",
      V: "𝗩",
      W: "𝗪",
      X: "𝗫",
      Y: "𝗬",
      Z: "𝗭",
      0: "𝟬",
      1: "𝟭",
      2: "𝟮",
      3: "𝟯",
      4: "𝟰",
      5: "𝟱",
      6: "𝟲",
      7: "𝟳",
      8: "𝟴",
      9: "𝟵",
    },
    italic: {
      a: "𝘢",
      b: "𝘣",
      c: "𝘤",
      d: "𝘥",
      e: "𝘦",
      f: "𝘧",
      g: "𝘨",
      h: "𝘩",
      i: "𝘪",
      j: "𝘫",
      k: "𝘬",
      l: "𝘭",
      m: "𝘮",
      n: "𝘯",
      o: "𝘰",
      p: "𝘱",
      q: "𝘲",
      r: "𝘳",
      s: "𝘴",
      t: "𝘵",
      u: "𝘶",
      v: "𝘷",
      w: "𝘸",
      x: "𝘹",
      y: "𝘺",
      z: "𝘻",
      A: "𝘈",
      B: "𝘉",
      C: "𝘊",
      D: "𝘋",
      E: "𝘌",
      F: "𝘍",
      G: "𝘎",
      H: "𝘏",
      I: "𝘐",
      J: "𝘑",
      K: "𝘒",
      L: "𝘓",
      M: "𝘔",
      N: "𝘕",
      O: "𝘖",
      P: "𝘗",
      Q: "𝘘",
      R: "𝘙",
      S: "𝘚",
      T: "𝘛",
      U: "𝘜",
      V: "𝘝",
      W: "𝘞",
      X: "𝘟",
      Y: "𝘠",
      Z: "𝘡",
    },
    script: {
      a: "𝓪",
      b: "𝓫",
      c: "𝓬",
      d: "𝓭",
      e: "𝓮",
      f: "𝓯",
      g: "𝓰",
      h: "𝓱",
      i: "𝓲",
      j: "𝓳",
      k: "𝓴",
      l: "𝓵",
      m: "𝓶",
      n: "𝓷",
      o: "𝓸",
      p: "𝓹",
      q: "𝓺",
      r: "𝓻",
      s: "𝓼",
      t: "𝓽",
      u: "𝓾",
      v: "𝓿",
      w: "𝔀",
      x: "𝔁",
      y: "𝔂",
      z: "𝔃",
      A: "𝓐",
      B: "𝓑",
      C: "𝓒",
      D: "𝓓",
      E: "𝓔",
      F: "𝓕",
      G: "𝓖",
      H: "𝓗",
      I: "𝓘",
      J: "𝓙",
      K: "𝓚",
      L: "𝓛",
      M: "𝓜",
      N: "𝓝",
      O: "𝓞",
      P: "𝓟",
      Q: "𝓠",
      R: "𝓡",
      S: "𝓢",
      T: "𝓣",
      U: "𝓤",
      V: "𝓥",
      W: "𝓦",
      X: "𝓧",
      Y: "𝓨",
      Z: "𝓩",
    },
    monospace: {
      a: "𝚊",
      b: "𝚋",
      c: "𝚌",
      d: "𝚍",
      e: "𝚎",
      f: "𝚏",
      g: "𝚐",
      h: "𝚑",
      i: "𝚒",
      j: "𝚓",
      k: "𝚔",
      l: "𝚕",
      m: "𝚖",
      n: "𝚗",
      o: "𝚘",
      p: "𝚙",
      q: "𝚚",
      r: "𝚛",
      s: "𝚜",
      t: "𝚝",
      u: "𝚞",
      v: "𝚟",
      w: "𝚠",
      x: "𝚡",
      y: "𝚢",
      z: "𝚣",
      A: "𝙰",
      B: "𝙱",
      C: "𝙲",
      D: "𝙳",
      E: "𝙴",
      F: "𝙵",
      G: "𝙶",
      H: "𝙷",
      I: "𝙸",
      J: "𝙹",
      K: "𝙺",
      L: "𝙻",
      M: "𝙼",
      N: "𝙽",
      O: "𝙾",
      P: "𝙿",
      Q: "𝚀",
      R: "𝚁",
      S: "𝚂",
      T: "𝚃",
      U: "𝚄",
      V: "𝚅",
      W: "𝚆",
      X: "𝚇",
      Y: "𝚈",
      Z: "𝚉",
      0: "𝟶",
      1: "𝟷",
      2: "𝟸",
      3: "𝟹",
      4: "𝟺",
      5: "𝟻",
      6: "𝟼",
      7: "𝟽",
      8: "𝟾",
      9: "𝟿",
    },
    boldItalic: {
      a: "𝙖",
      b: "𝙗",
      c: "𝙘",
      d: "𝙙",
      e: "𝙚",
      f: "𝙛",
      g: "𝙜",
      h: "𝙝",
      i: "𝙞",
      j: "𝙟",
      k: "𝙠",
      l: "𝙡",
      m: "𝙢",
      n: "𝙣",
      o: "𝙤",
      p: "𝙥",
      q: "𝙦",
      r: "𝙧",
      s: "𝙨",
      t: "𝙩",
      u: "𝙪",
      v: "𝙫",
      w: "𝙬",
      x: "𝙭",
      y: "𝙮",
      z: "𝙯",
      A: "𝘼",
      B: "𝘽",
      C: "𝘾",
      D: "𝘿",
      E: "𝙀",
      F: "𝙁",
      G: "𝙂",
      H: "𝙃",
      I: "𝙄",
      J: "𝙅",
      K: "𝙆",
      L: "𝙇",
      M: "𝙈",
      N: "𝙉",
      O: "𝙊",
      P: "𝙋",
      Q: "𝙌",
      R: "𝙍",
      S: "𝙎",
      T: "𝙏",
      U: "𝙐",
      V: "𝙑",
      W: "𝙒",
      X: "𝙓",
      Y: "𝙔",
      Z: "𝙕",
    },

    fraktur: {
      a: "𝔞",
      b: "𝔟",
      c: "𝔠",
      d: "𝔡",
      e: "𝔢",
      f: "𝔣",
      g: "𝔤",
      h: "𝔥",
      i: "𝔦",
      j: "𝔧",
      k: "𝔨",
      l: "𝔩",
      m: "𝔪",
      n: "𝔫",
      o: "𝔬",
      p: "𝔭",
      q: "𝔮",
      r: "𝔯",
      s: "𝔰",
      t: "𝔱",
      u: "𝔲",
      v: "𝔳",
      w: "𝔴",
      x: "𝔵",
      y: "𝔶",
      z: "𝔷",
      A: "𝔄",
      B: "𝔅",
      C: "ℭ",
      D: "𝔇",
      E: "𝔈",
      F: "𝔉",
      G: "𝔊",
      H: "ℌ",
      I: "ℑ",
      J: "𝔍",
      K: "𝔎",
      L: "𝔏",
      M: "𝔐",
      N: "𝔑",
      O: "𝔒",
      P: "𝔓",
      Q: "𝔔",
      R: "ℜ",
      S: "𝔖",
      T: "𝔗",
      U: "𝔘",
      V: "𝔙",
      W: "𝔚",
      X: "𝔛",
      Y: "𝔜",
      Z: "ℨ",
    },
    doubleStruck: {
      a: "𝕒",
      b: "𝕓",
      c: "𝕔",
      d: "𝕕",
      e: "𝕖",
      f: "𝕗",
      g: "𝕘",
      h: "𝕙",
      i: "𝕚",
      j: "𝕛",
      k: "𝕜",
      l: "𝕝",
      m: "𝕞",
      n: "𝕟",
      o: "𝕠",
      p: "𝕡",
      q: "𝕢",
      r: "𝕣",
      s: "𝕤",
      t: "𝕥",
      u: "𝕦",
      v: "𝕧",
      w: "𝕨",
      x: "𝕩",
      y: "𝕪",
      z: "𝕫",
      A: "𝔸",
      B: "𝔹",
      C: "ℂ",
      D: "𝔻",
      E: "𝔼",
      F: "𝔽",
      G: "𝔾",
      H: "ℍ",
      I: "𝕀",
      J: "𝕁",
      K: "𝕂",
      L: "𝕃",
      M: "𝕄",
      N: "ℕ",
      O: "𝕆",
      P: "ℙ",
      Q: "ℚ",
      R: "ℝ",
      S: "𝕊",
      T: "𝕋",
      U: "𝕌",
      V: "𝕍",
      W: "𝕎",
      X: "𝕏",
      Y: "𝕐",
      Z: "ℤ",
      0: "𝟘",
      1: "𝟙",
      2: "𝟚",
      3: "𝟛",
      4: "𝟜",
      5: "𝟝",
      6: "𝟞",
      7: "𝟟",
      8: "𝟠",
      9: "𝟡",
    },
    smallCaps: {
      a: "ᴀ",
      b: "ʙ",
      c: "ᴄ",
      d: "ᴅ",
      e: "ᴇ",
      f: "ғ",
      g: "ɢ",
      h: "ʜ",
      i: "ɪ",
      j: "ᴊ",
      k: "ᴋ",
      l: "ʟ",
      m: "ᴍ",
      n: "ɴ",
      o: "ᴏ",
      p: "ᴘ",
      q: "ǫ",
      r: "ʀ",
      s: "s",
      t: "ᴛ",
      u: "ᴜ",
      v: "ᴠ",
      w: "ᴡ",
      x: "x",
      y: "ʏ",
      z: "ᴢ",
    },
    upsideDown: {
      a: "ɐ",
      b: "q",
      c: "ɔ",
      d: "p",
      e: "ǝ",
      f: "ɟ",
      g: "ƃ",
      h: "ɥ",
      i: "ᴉ",
      j: "ɾ",
      k: "ʞ",
      l: "l",
      m: "ɯ",
      n: "u",
      o: "o",
      p: "d",
      q: "b",
      r: "ɹ",
      s: "s",
      t: "ʇ",
      u: "n",
      v: "ʌ",
      w: "ʍ",
      x: "x",
      y: "ʎ",
      z: "z",
    },
    strikethrough: {
      // Using combining long stroke overlay U+0336
      a: "a\u0336",
      b: "b\u0336",
      c: "c\u0336",
      d: "d\u0336",
      e: "e\u0336",
      f: "f\u0336",
      g: "g\u0336",
      h: "h\u0336",
      i: "i\u0336",
      j: "j\u0336",
      k: "k\u0336",
      l: "l\u0336",
      m: "m\u0336",
      n: "n\u0336",
      o: "o\u0336",
      p: "p\u0336",
      q: "q\u0336",
      r: "r\u0336",
      s: "s\u0336",
      t: "t\u0336",
      u: "u\u0336",
      v: "v\u0336",
      w: "w\u0336",
      x: "x\u0336",
      y: "y\u0336",
      z: "z\u0336",
      A: "A\u0336",
      B: "B\u0336",
      C: "C\u0336",
      D: "D\u0336",
      E: "E\u0336",
      F: "F\u0336",
      G: "G\u0336",
      H: "H\u0336",
      I: "I\u0336",
      J: "J\u0336",
      K: "K\u0336",
      L: "L\u0336",
      M: "M\u0336",
      N: "N\u0336",
      O: "O\u0336",
      P: "P\u0336",
      Q: "Q\u0336",
      R: "R\u0336",
      S: "S\u0336",
      T: "T\u0336",
      U: "U\u0336",
      V: "V\u0336",
      W: "W\u0336",
      X: "X\u0336",
      Y: "Y\u0336",
      Z: "Z\u0336",
      0: "0\u0336",
      1: "1\u0336",
      2: "2\u0336",
      3: "3\u0336",
      4: "4\u0336",
      5: "5\u0336",
      6: "6\u0336",
      7: "7\u0336",
      8: "8\u0336",
      9: "9\u0336",
    },
  };

  // Common currency symbols
  const currencySymbols = {
    usd: "$",
    eur: "€",
    gbp: "£",
    jpy: "¥",
    cny: "¥",
    inr: "₹",
    rub: "₽",
    krw: "₩",
    btc: "₿",
    baht: "฿",
    ngn: "₦",
    peso: "₱",
    brazil: "R$",
    won: "₩",
    lira: "₺",
    bitcoin: "₿",
    cent: "¢",
    dollar: "$",
    euro: "€",
    pound: "£",
    yen: "¥",
    rupee: "₹",
    ruble: "₽",
    genericCurrency: "¤",
  };

  // Special characters organized by language/region
  const specialCharacters = {
    yoruba: {
      name: "Yoruba",
      chars: [
        { char: "ẹ", name: "e with dot below" },
        { char: "Ẹ", name: "E with dot below" },
        { char: "ọ", name: "o with dot below" },
        { char: "Ọ", name: "O with dot below" },
        { char: "ṣ", name: "s with dot below" },
        { char: "Ṣ", name: "S with dot below" },
        { char: "ẹ́", name: "e with dot below and acute" },
        { char: "Ẹ́", name: "E with dot below and acute" },
        { char: "ọ́", name: "o with dot below and acute" },
        { char: "Ọ́", name: "O with dot below and acute" },
        { char: "ṣ́", name: "s with dot below and acute" },
        { char: "Ṣ́", name: "S with dot below and acute" },
      ],
    },
    eastern_european: {
      name: "Eastern European",
      chars: [
        { char: "č", name: "c with caron" },
        { char: "Č", name: "C with caron" },
        { char: "š", name: "s with caron" },
        { char: "Š", name: "S with caron" },
        { char: "ž", name: "z with caron" },
        { char: "Ž", name: "Z with caron" },
        { char: "đ", name: "d with stroke" },
        { char: "Đ", name: "D with stroke" },
        { char: "ć", name: "c with acute" },
        { char: "Ć", name: "C with acute" },
        { char: "ň", name: "n with caron" },
        { char: "Ň", name: "N with caron" },
        { char: "ř", name: "r with caron" },
        { char: "Ř", name: "R with caron" },
        { char: "ľ", name: "l with caron" },
        { char: "Ľ", name: "L with caron" },
        { char: "ť", name: "t with caron" },
        { char: "Ť", name: "T with caron" },
      ],
    },
    latin_extended: {
      name: "Latin Extended",
      chars: [
        { char: "ñ", name: "n with tilde" },
        { char: "Ñ", name: "N with tilde" },
        { char: "á", name: "a with acute" },
        { char: "Á", name: "A with acute" },
        { char: "é", name: "e with acute" },
        { char: "É", name: "E with acute" },
        { char: "í", name: "i with acute" },
        { char: "Í", name: "I with acute" },
        { char: "ó", name: "o with acute" },
        { char: "Ó", name: "O with acute" },
        { char: "ú", name: "u with acute" },
        { char: "Ú", name: "U with acute" },
        { char: "à", name: "a with grave" },
        { char: "À", name: "A with grave" },
        { char: "è", name: "e with grave" },
        { char: "È", name: "E with grave" },
        { char: "ì", name: "i with grave" },
        { char: "Ì", name: "I with grave" },
        { char: "ò", name: "o with grave" },
        { char: "Ò", name: "O with grave" },
        { char: "ù", name: "u with grave" },
        { char: "Ù", name: "U with grave" },
        { char: "ä", name: "a with diaeresis" },
        { char: "Ä", name: "A with diaeresis" },
        { char: "ë", name: "e with diaeresis" },
        { char: "Ë", name: "E with diaeresis" },
        { char: "ï", name: "i with diaeresis" },
        { char: "Ï", name: "I with diaeresis" },
        { char: "ö", name: "o with diaeresis" },
        { char: "Ö", name: "O with diaeresis" },
        { char: "ü", name: "u with diaeresis" },
        { char: "Ü", name: "U with diaeresis" },
        { char: "â", name: "a with circumflex" },
        { char: "Â", name: "A with circumflex" },
        { char: "ê", name: "e with circumflex" },
        { char: "Ê", name: "E with circumflex" },
        { char: "î", name: "i with circumflex" },
        { char: "Î", name: "I with circumflex" },
        { char: "ô", name: "o with circumflex" },
        { char: "Ô", name: "O with circumflex" },
        { char: "û", name: "u with circumflex" },
        { char: "Û", name: "U with circumflex" },
        { char: "ã", name: "a with tilde" },
        { char: "Ã", name: "A with tilde" },
        { char: "õ", name: "o with tilde" },
        { char: "Õ", name: "O with tilde" },
        { char: "ç", name: "c with cedilla" },
        { char: "Ç", name: "C with cedilla" },
      ],
    },
    mathematical: {
      name: "Mathematical",
      chars: [
        { char: "±", name: "plus-minus" },
        { char: "×", name: "multiplication" },
        { char: "÷", name: "division" },
        { char: "≠", name: "not equal" },
        { char: "≤", name: "less than or equal" },
        { char: "≥", name: "greater than or equal" },
        { char: "≈", name: "approximately equal" },
        { char: "∞", name: "infinity" },
        { char: "∑", name: "summation" },
        { char: "∏", name: "product" },
        { char: "√", name: "square root" },
        { char: "∂", name: "partial derivative" },
        { char: "∆", name: "delta" },
        { char: "π", name: "pi" },
        { char: "α", name: "alpha" },
        { char: "β", name: "beta" },
        { char: "γ", name: "gamma" },
        { char: "θ", name: "theta" },
        { char: "λ", name: "lambda" },
        { char: "µ", name: "mu" },
        { char: "σ", name: "sigma" },
        { char: "φ", name: "phi" },
        { char: "ω", name: "omega" },
      ],
    },
    symbols: {
      name: "Symbols & Punctuation",
      chars: [
        { char: "•", name: "bullet" },
        { char: "‣", name: "triangular bullet" },
        { char: "‰", name: "per mille" },
        { char: "§", name: "section" },
        { char: "¶", name: "pilcrow" },
        { char: "†", name: "dagger" },
        { char: "‡", name: "double dagger" },
        { char: "‹", name: "single left angle quotation" },
        { char: "›", name: "single right angle quotation" },
        { char: "«", name: "left double angle quotation" },
        { char: "»", name: "right double angle quotation" },
        { char: "—", name: "em dash" },
        { char: "–", name: "en dash" },
        { char: "…", name: "ellipsis" },
        { char: "™", name: "trademark" },
        { char: "®", name: "registered" },
        { char: "©", name: "copyright" },
        { char: "°", name: "degree" },
        { char: "¼", name: "one quarter" },
        { char: "½", name: "one half" },
        { char: "¾", name: "three quarters" },
      ],
    },
  };

  const sampleText = {
    bold: "𝗕𝗼𝗹𝗱 𝗧𝗲𝘅𝘁",
    italic: "𝘐𝘵𝘢𝘭𝘪𝘤 𝘛𝘦𝘹𝘵",
    script: "𝓢𝓬𝓻𝓲𝓹𝓽 𝓣𝓮𝔁𝓽",
    monospace: "𝙼𝚘𝚗𝚘𝚜𝚙𝚊𝚌𝚎 𝚃𝚎𝚡𝚝",
    boldItalic: "𝙱𝚘𝚕𝚍 𝙸𝚝𝚊𝚕𝚒𝚌 𝚃𝚎𝚡𝚝",
    fraktur: "𝔉𝔯𝔞𝔨𝔱𝔲𝔯 𝔗𝔢𝔵𝔱",
    doubleStruck: "𝕯𝖔𝖚𝖇𝖑𝖊-𝕾𝖙𝖗𝖚𝖈𝖐 𝕿𝖊𝖝𝖙",
    smallCaps: "ꜱᴍᴀʟʟ ᴄᴀᴘs ᴛᴇxᴛ",
    upsideDown: "ɐʍʇ ʇɐɥʍ ʎʍ",
    strikethrough:
      "s\u0336t\u0336r\u0336i\u0336k\u0336e\u0336t\u0336h\u0336r\u0336o\u0336u\u0336g\u0336h\u0336",
  };

  // Ensure UnicodeStyler namespace exists
  window.UnicodeStyler = window.UnicodeStyler || {};
  window.UnicodeStyler.styleMaps = styleMaps;
  window.UnicodeStyler.currencySymbols = currencySymbols;
  window.UnicodeStyler.specialCharacters = specialCharacters;
  window.UnicodeStyler.sampleText = sampleText;
})();
